/*******************************************************************************
* Copyright 2001-2023 Intel Corporation.
*
* This software and the related documents are Intel copyrighted  materials,  and
* your use of  them is  governed by the  express license  under which  they were
* provided to you (License).  Unless the License provides otherwise, you may not
* use, modify, copy, publish, distribute,  disclose or transmit this software or
* the related documents without Intel's prior written permission.
*
* This software and the related documents  are provided as  is,  with no express
* or implied  warranties,  other  than those  that are  expressly stated  in the
* License.
*******************************************************************************/

/*
!  Content:
!    vmlSetMode/vmlGetMode  Example Program Text
!******************************************************************************/

#include <stdio.h>
#include "mkl_vml.h"

/**
 * @brief Print VM mode name
 *
 * Printing of VM mode name
 *
 * @param[in] mode         VM mode
 *
 */
void PrintTextVmlMode(unsigned int mode)
{
  switch(mode&VML_ACCURACY_MASK) {
    case 0x001: {
                fprintf(stdout, "VML_LA");
                break;
    }
    case 0x002: {
                fprintf(stdout, "VML_HA");
                break;
    }
  }
  switch(mode&VML_FPUMODE_MASK) {
    case 0x000: {
                fprintf(stdout, " | VML_DEFAULT_PRECISION");
                break;
    }
    case 0x010: {
                fprintf(stdout, " | VML_FLOAT_CONSISTENT");
                break;
    }
    case 0x020: {
                fprintf(stdout, " | VML_DOUBLE_CONSISTENT");
                break;
    }
    case 0x030: {
                fprintf(stdout, " | VML_RESTORE");
                break;
    }
  }
  if(mode&VML_ERRMODE_IGNORE) {
    fprintf(stdout, " | VML_ERRMODE_IGNORE");
  }
  else if (mode&VML_ERRMODE_NOERR)
  {
    fprintf(stdout, " | VML_ERRMODE_NOERR");
  }
  else {
    if(mode&VML_ERRMODE_ERRNO) {
      fprintf(stdout, " | VML_ERRMODE_ERRNO");
    }
    if(mode&VML_ERRMODE_STDERR) {
      fprintf(stdout, " | VML_ERRMODE_STDERR");
    }
    if(mode&VML_ERRMODE_EXCEPT) {
      fprintf(stdout, " | VML_ERRMODE_EXCEPT");
    }
    if(mode&VML_ERRMODE_CALLBACK) {
      fprintf(stdout, " | VML_ERRMODE_CALLBACK");
    }
  }
}

/**
 * @brief Main function for Set\GetMode test
 *
 * Main performs simple test of vmlSet\GetMode function
 *
 * @param[in] argc         Number of arguments
 * @param[in] argv         Pointer to argument strings
 * @return                 -1 for FAIL or 0 for PASS
 *
 */
int main (int argc, char **argv)
{
  int ret = VML_STATUS_OK;
  unsigned MKL_INT mode;

  fprintf (stdout, "classic c vm_mode: started...\n"); fflush (stdout);

  mode=(unsigned MKL_INT)vmlGetMode();
  fprintf(stdout, "\tDefault value of vmlMode: ");
  PrintTextVmlMode((unsigned int)mode);
  fprintf(stdout, "\t (0x%x)\n",(unsigned int)mode);

  mode=(unsigned MKL_INT)(VML_LA|VML_FLOAT_CONSISTENT|VML_ERRMODE_IGNORE);
  vmlSetMode(mode);
  mode=(unsigned MKL_INT)vmlGetMode();
  fprintf(stdout, "\tValue of vmlMode after using vmlSetMode: ");
  PrintTextVmlMode((unsigned int)mode);
  fprintf(stdout, "\t (0x%x)\n",(unsigned int)mode);

  ret = (vmlGetErrStatus() < VML_STATUS_OK)?-1:0;

  fprintf (stdout, "classic c vm_mode: %s\n\n", (ret)?"FAIL":"PASS");

  return ret;
}
