/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.util.List;
import java.util.Properties;
import org.testng.ISuite;
import org.testng.internal.Utils;
import org.testng.reporters.AbstractXmlReporter;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.XmlSuite;

public class XMLReporter
extends AbstractXmlReporter {
    @Override
    public void generateReport(List<XmlSuite> xmlSuites, List<ISuite> suites, String outputDirectory) {
        if (Utils.isStringEmpty(this.getConfig().getOutputDirectory())) {
            this.getConfig().setOutputDirectory(outputDirectory);
        }
        AbstractXmlReporter.Count count = AbstractXmlReporter.Count.Builder.builder().build();
        for (ISuite s : suites) {
            count.add(this.computeCountForSuite(s));
        }
        XMLStringBuffer rootBuffer = new XMLStringBuffer();
        Properties p = this.writeSummaryCount(count);
        rootBuffer.push("testng-results", p);
        this.writeReporterOutput(rootBuffer);
        for (ISuite suite : suites) {
            this.writeSuite(rootBuffer, suite);
        }
        rootBuffer.pop();
        Utils.writeUtf8File(this.getConfig().getOutputDirectory(), this.fileName(), rootBuffer, null);
    }
}

