﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/pinpoint/Pinpoint_EXPORTS.h>
#include <aws/pinpoint/model/SegmentResponse.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Pinpoint {
namespace Model {
class UpdateSegmentResult {
 public:
  AWS_PINPOINT_API UpdateSegmentResult() = default;
  AWS_PINPOINT_API UpdateSegmentResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_PINPOINT_API UpdateSegmentResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{

  inline const SegmentResponse& GetSegmentResponse() const { return m_segmentResponse; }
  template <typename SegmentResponseT = SegmentResponse>
  void SetSegmentResponse(SegmentResponseT&& value) {
    m_segmentResponseHasBeenSet = true;
    m_segmentResponse = std::forward<SegmentResponseT>(value);
  }
  template <typename SegmentResponseT = SegmentResponse>
  UpdateSegmentResult& WithSegmentResponse(SegmentResponseT&& value) {
    SetSegmentResponse(std::forward<SegmentResponseT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  UpdateSegmentResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  SegmentResponse m_segmentResponse;

  Aws::String m_requestId;
  bool m_segmentResponseHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Pinpoint
}  // namespace Aws
