/*
 * Decompiled with CFR 0.152.
 */
package org.cugos.wkg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.cugos.wkg.CircularString;
import org.cugos.wkg.CompoundCurve;
import org.cugos.wkg.Coordinate;
import org.cugos.wkg.Curve;
import org.cugos.wkg.CurvePolygon;
import org.cugos.wkg.Dimension;
import org.cugos.wkg.Geometry;
import org.cugos.wkg.GeometryCollection;
import org.cugos.wkg.LineString;
import org.cugos.wkg.LinearRing;
import org.cugos.wkg.MultiCurve;
import org.cugos.wkg.MultiLineString;
import org.cugos.wkg.MultiPoint;
import org.cugos.wkg.MultiPolygon;
import org.cugos.wkg.MultiSurface;
import org.cugos.wkg.Point;
import org.cugos.wkg.PolyHedralSurface;
import org.cugos.wkg.Polygon;
import org.cugos.wkg.Reader;
import org.cugos.wkg.Surface;
import org.cugos.wkg.Tin;
import org.cugos.wkg.Triangle;
import org.cugos.wkg.internal.WKTBaseListener;
import org.cugos.wkg.internal.WKTLexer;
import org.cugos.wkg.internal.WKTParser;

public class WKTReader
implements Reader<String> {
    @Override
    public Geometry read(String wkt) {
        WKTLexer lexer = new WKTLexer((CharStream)CharStreams.fromString((String)wkt));
        WKTParser parser = new WKTParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new IllegalStateException("failed to parse at line " + line + " due to " + msg, e);
            }
        });
        final Stack geometries = new Stack();
        final Var<Dimension> dimension = new Var<Dimension>();
        final Var srid = new Var();
        dimension.set(Dimension.Two);
        parser.addParseListener(new WKTBaseListener(){

            @Override
            public void exitDimension(WKTParser.DimensionContext ctx) {
                if (ctx.M() != null) {
                    dimension.set(Dimension.TwoMeasured);
                } else if (ctx.Z() != null) {
                    dimension.set(Dimension.Three);
                } else if (ctx.ZM() != null) {
                    dimension.set(Dimension.ThreeMeasured);
                }
            }

            @Override
            public void exitSrid(WKTParser.SridContext ctx) {
                srid.set(ctx.Number().getText());
            }

            @Override
            public void exitPoint(WKTParser.PointContext ctx) {
                Point point = ctx.coordinate() == null ? Point.createEmpty() : WKTReader.this.point(ctx, dimension, srid);
                geometries.push(point);
            }

            @Override
            public void exitLineString(WKTParser.LineStringContext ctx) {
                LineString lineString = ctx.coordinates() == null ? LineString.createEmpty() : WKTReader.this.lineString(ctx, (Var<Dimension>)dimension, (Var<String>)srid);
                geometries.push(lineString);
            }

            @Override
            public void exitCircularString(WKTParser.CircularStringContext ctx) {
                CircularString lineString = ctx.coordinates() == null ? CircularString.createEmpty() : new CircularString(WKTReader.this.coordinates(ctx.coordinates(), dimension), (Dimension)((Object)dimension.get()), (String)srid.get());
                geometries.push(lineString);
            }

            @Override
            public void exitMultiPoint(WKTParser.MultiPointContext ctx) {
                MultiPoint lineString = ctx.coordinates() == null && ctx.coordinatesets() == null ? MultiPoint.createEmpty() : WKTReader.this.multiPoint(ctx, dimension, srid);
                geometries.push(lineString);
            }

            @Override
            public void exitPolygon(WKTParser.PolygonContext ctx) {
                Polygon polygon = ctx.coordinatesets() == null || ctx.coordinatesets().coordinates().size() == 0 ? Polygon.createEmpty() : WKTReader.this.polygon(ctx.coordinatesets(), dimension, srid);
                geometries.push(polygon);
            }

            @Override
            public void exitTriangle(WKTParser.TriangleContext ctx) {
                Triangle polygon = ctx.coordinatesets() == null || ctx.coordinatesets().coordinates().size() == 0 ? Triangle.createEmpty() : WKTReader.this.triangle(ctx.coordinatesets().coordinates(), dimension, srid);
                geometries.push(polygon);
            }

            @Override
            public void exitTin(WKTParser.TinContext ctx) {
                Tin tin;
                if (ctx.coordinatesetsset() == null || ctx.coordinatesetsset().coordinatesets().isEmpty()) {
                    tin = Tin.createEmpty();
                } else {
                    ArrayList<Triangle> triangles = new ArrayList<Triangle>();
                    for (WKTParser.CoordinatesetsContext cctx : ctx.coordinatesetsset().coordinatesets()) {
                        List<WKTParser.CoordinatesContext> coordinatesContexts = cctx.coordinates();
                        triangles.add(WKTReader.this.triangle(coordinatesContexts, dimension, srid));
                    }
                    tin = new Tin(triangles, (Dimension)((Object)dimension.get()), (String)srid.get());
                }
                geometries.push(tin);
            }

            @Override
            public void exitMultiLineString(WKTParser.MultiLineStringContext ctx) {
                MultiLineString multiLineString;
                if (ctx.coordinatesets() == null || ctx.coordinatesets().coordinates().size() == 0) {
                    multiLineString = MultiLineString.createEmpty();
                } else {
                    ArrayList<LineString> linesStrings = new ArrayList<LineString>();
                    for (WKTParser.CoordinatesContext cctx : ctx.coordinatesets().coordinates()) {
                        linesStrings.add(new LineString(WKTReader.this.coordinates(cctx, dimension), (Dimension)((Object)dimension.get()), (String)srid.get()));
                    }
                    multiLineString = new MultiLineString((List<LineString>)linesStrings, (Dimension)((Object)dimension.get()), (String)srid.get());
                }
                geometries.push(multiLineString);
            }

            @Override
            public void exitPolyHedralSurface(WKTParser.PolyHedralSurfaceContext ctx) {
                PolyHedralSurface polyHedralSurface;
                if (ctx.coordinatesetsset() == null || ctx.coordinatesetsset().coordinatesets().isEmpty()) {
                    polyHedralSurface = PolyHedralSurface.createEmpty();
                } else {
                    ArrayList<Polygon> polygons = new ArrayList<Polygon>();
                    for (WKTParser.CoordinatesetsContext cctx : ctx.coordinatesetsset().coordinatesets()) {
                        polygons.add(WKTReader.this.polygon(cctx, dimension, srid));
                    }
                    polyHedralSurface = new PolyHedralSurface(polygons, (Dimension)((Object)dimension.get()), (String)srid.get());
                }
                geometries.push(polyHedralSurface);
            }

            @Override
            public void exitMultiPolygon(WKTParser.MultiPolygonContext ctx) {
                MultiPolygon multiPolygon;
                if (ctx.coordinatesetsset() == null || ctx.coordinatesetsset().coordinatesets().isEmpty()) {
                    multiPolygon = MultiPolygon.createEmpty();
                } else {
                    ArrayList<Polygon> polygons = new ArrayList<Polygon>();
                    for (WKTParser.CoordinatesetsContext cctx : ctx.coordinatesetsset().coordinatesets()) {
                        polygons.add(WKTReader.this.polygon(cctx, dimension, srid));
                    }
                    multiPolygon = new MultiPolygon((List<Polygon>)polygons, (Dimension)((Object)dimension.get()), (String)srid.get());
                }
                geometries.push(multiPolygon);
            }

            @Override
            public void exitCurvePolygon(WKTParser.CurvePolygonContext ctx) {
                CurvePolygon curvePolygon;
                if (ctx.curvePolygonItems() == null || ctx.curvePolygonItems().curvePolygonElements() == null) {
                    curvePolygon = CurvePolygon.createEmpty();
                } else {
                    ArrayList<Curve> curves = new ArrayList<Curve>();
                    for (WKTParser.CurvePolygonElementsContext cpext : ctx.curvePolygonItems().curvePolygonElements()) {
                        if (cpext.circularString() != null) {
                            curves.add((Curve)geometries.pop());
                            continue;
                        }
                        if (cpext.compoundCurve() != null) {
                            curves.add((Curve)geometries.pop());
                            continue;
                        }
                        if (cpext.lineStringCoordinates() == null) continue;
                        curves.add(WKTReader.this.lineString(cpext.lineStringCoordinates().coordinates(), (Var<Dimension>)dimension, (Var<String>)srid));
                    }
                    curvePolygon = new CurvePolygon((Curve)curves.get(0), curves.subList(1, curves.size()), (Dimension)((Object)dimension.get()), (String)srid.get());
                }
                geometries.push(curvePolygon);
            }

            @Override
            public void exitCompoundCurve(WKTParser.CompoundCurveContext ctx) {
                CompoundCurve compoundCurve;
                if (ctx.compoundCurveItems() == null || ctx.compoundCurveItems().compoundCurveElements() == null) {
                    compoundCurve = CompoundCurve.createEmpty();
                } else {
                    ArrayList<Curve> curves = new ArrayList<Curve>();
                    for (WKTParser.CompoundCurveElementsContext ccext : ctx.compoundCurveItems().compoundCurveElements()) {
                        if (ccext.circularString() != null) {
                            curves.add((Curve)geometries.pop());
                            continue;
                        }
                        if (ccext.lineStringCoordinates() == null) continue;
                        curves.add(WKTReader.this.lineString(ccext.lineStringCoordinates().coordinates(), (Var<Dimension>)dimension, (Var<String>)srid));
                    }
                    compoundCurve = new CompoundCurve(curves, (Dimension)((Object)dimension.get()), (String)srid.get());
                }
                geometries.push(compoundCurve);
            }

            @Override
            public void exitMultiCurve(WKTParser.MultiCurveContext ctx) {
                MultiCurve multiCurve;
                if (ctx.multiCurveItems() == null || ctx.multiCurveItems().multiCurveElements() == null) {
                    multiCurve = MultiCurve.createEmpty();
                } else {
                    ArrayList<Curve> curves = new ArrayList<Curve>();
                    for (WKTParser.MultiCurveElementsContext ccext : ctx.multiCurveItems().multiCurveElements()) {
                        if (ccext.circularString() != null) {
                            curves.add((CircularString)geometries.pop());
                            continue;
                        }
                        if (ccext.lineStringCoordinates() != null) {
                            curves.add(WKTReader.this.lineString(ccext.lineStringCoordinates().coordinates(), (Var<Dimension>)dimension, (Var<String>)srid));
                            continue;
                        }
                        if (ccext.compoundCurve() == null) continue;
                        curves.add((CompoundCurve)geometries.pop());
                    }
                    multiCurve = new MultiCurve((List<Curve>)curves, (Dimension)((Object)dimension.get()), (String)srid.get());
                }
                geometries.push(multiCurve);
            }

            @Override
            public void exitMultiSurface(WKTParser.MultiSurfaceContext ctx) {
                MultiSurface multiSurface;
                if (ctx.multiSurfaceItems() == null || ctx.multiSurfaceItems().multiSurfaceElements() == null) {
                    multiSurface = MultiSurface.createEmpty();
                } else {
                    ArrayList<Surface> surfaces = new ArrayList<Surface>();
                    for (WKTParser.MultiSurfaceElementsContext ccext : ctx.multiSurfaceItems().multiSurfaceElements()) {
                        if (ccext.curvePolygon() != null) {
                            surfaces.add((CurvePolygon)geometries.pop());
                            continue;
                        }
                        if (ccext.polygonCoordinates() == null) continue;
                        surfaces.add(WKTReader.this.polygon(ccext.polygonCoordinates().coordinatesets(), dimension, srid));
                    }
                    multiSurface = new MultiSurface((List<Surface>)surfaces, (Dimension)((Object)dimension.get()), (String)srid.get());
                }
                geometries.push(multiSurface);
            }

            @Override
            public void exitGeometryCollection(WKTParser.GeometryCollectionContext ctx) {
                GeometryCollection geometryCollection;
                if (ctx.geometryCollectionItems() == null || ctx.geometryCollectionItems().geometryCollectionElements() == null) {
                    geometryCollection = GeometryCollection.createEmpty();
                } else {
                    ArrayList<Geometry> geometryList = new ArrayList<Geometry>();
                    for (WKTParser.GeometryCollectionElementsContext ccext : ctx.geometryCollectionItems().geometryCollectionElements()) {
                        geometryList.add((Geometry)geometries.pop());
                    }
                    Collections.reverse(geometryList);
                    geometryCollection = new GeometryCollection((List<Geometry>)geometryList, (Dimension)((Object)dimension.get()), (String)srid.get());
                }
                geometries.push(geometryCollection);
            }
        });
        parser.wkt();
        return geometries.isEmpty() ? null : (Geometry)geometries.pop();
    }

    @Override
    public String getName() {
        return "WKT";
    }

    private Coordinate coordinate(WKTParser.CoordinateContext ctx, Var<Dimension> dimension) {
        double x = Double.parseDouble(ctx.Number(0).getText());
        double y = Double.parseDouble(ctx.Number(1).getText());
        if (dimension.get() == Dimension.Two && ctx.Number().size() == 3) {
            dimension.set(Dimension.Three);
        } else if (dimension.get() == Dimension.Two && ctx.Number().size() == 4) {
            dimension.set(Dimension.ThreeMeasured);
        }
        if (dimension.get() == Dimension.TwoMeasured) {
            return Coordinate.create2DM(x, y, Double.parseDouble(ctx.Number(2).getText()));
        }
        if (dimension.get() == Dimension.Three) {
            return Coordinate.create3D(x, y, Double.parseDouble(ctx.Number(2).getText()));
        }
        if (dimension.get() == Dimension.ThreeMeasured) {
            return Coordinate.create3DM(x, y, Double.parseDouble(ctx.Number(2).getText()), Double.parseDouble(ctx.Number(3).getText()));
        }
        return Coordinate.create2D(x, y);
    }

    private List<Coordinate> coordinates(WKTParser.CoordinatesContext ctx, Var<Dimension> dimension) {
        ArrayList<Coordinate> points = new ArrayList<Coordinate>();
        for (WKTParser.CoordinateContext cctx : ctx.coordinate()) {
            points.add(this.coordinate(cctx, dimension));
        }
        return points;
    }

    private List<Point> points(WKTParser.CoordinatesContext ctx, Var<Dimension> dimension, Var<String> srid) {
        ArrayList<Point> points = new ArrayList<Point>();
        for (Coordinate coordinate : this.coordinates(ctx, dimension)) {
            points.add(new Point(coordinate, dimension.get(), srid.get()));
        }
        return points;
    }

    private List<Point> points(WKTParser.CoordinatesetsContext ctx, Var<Dimension> dimension, Var<String> srid) {
        ArrayList<Point> points = new ArrayList<Point>();
        List<WKTParser.CoordinatesContext> coordinatesContexts = ctx.coordinates();
        for (WKTParser.CoordinatesContext cctx : coordinatesContexts) {
            points.addAll(this.points(cctx, dimension, srid));
        }
        return points;
    }

    private Point point(WKTParser.PointContext ctx, Var<Dimension> dimension, Var<String> srid) {
        return new Point(this.coordinate(ctx.coordinate(), dimension), dimension.get(), srid.get());
    }

    private LineString lineString(WKTParser.LineStringContext ctx, Var<Dimension> dimension, Var<String> srid) {
        return new LineString(this.coordinates(ctx.coordinates(), dimension), dimension.get(), srid.get());
    }

    private LineString lineString(WKTParser.CoordinatesContext ctx, Var<Dimension> dimension, Var<String> srid) {
        return new LineString(this.coordinates(ctx, dimension), dimension.get(), srid.get());
    }

    private Polygon polygon(WKTParser.CoordinatesetsContext cctx, Var<Dimension> dimension, Var<String> srid) {
        List<WKTParser.CoordinatesContext> coordinatesContexts = cctx.coordinates();
        LinearRing linearRing = new LinearRing(this.coordinates(coordinatesContexts.get(0), dimension), dimension.get(), srid.get());
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        for (int i = 1; i < coordinatesContexts.size(); ++i) {
            LinearRing hole = new LinearRing(this.coordinates(coordinatesContexts.get(i), dimension), dimension.get(), srid.get());
            holes.add(hole);
        }
        return new Polygon(linearRing, holes, dimension.get(), srid.get());
    }

    private MultiPoint multiPoint(WKTParser.MultiPointContext ctx, Var<Dimension> dimension, Var<String> srid) {
        if (ctx.coordinates() != null) {
            return new MultiPoint(this.points(ctx.coordinates(), dimension, srid), dimension.get(), srid.get());
        }
        return new MultiPoint(this.points(ctx.coordinatesets(), dimension, srid), dimension.get(), srid.get());
    }

    private Triangle triangle(List<WKTParser.CoordinatesContext> coordinatesContexts, Var<Dimension> dimension, Var<String> srid) {
        LinearRing linearRing = new LinearRing(this.coordinates(coordinatesContexts.get(0), dimension), dimension.get(), srid.get());
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        for (int i = 1; i < coordinatesContexts.size(); ++i) {
            LinearRing hole = new LinearRing(this.coordinates(coordinatesContexts.get(i), dimension), dimension.get(), srid.get());
            holes.add(hole);
        }
        return new Triangle(linearRing, holes, dimension.get(), srid.get());
    }

    private static class Var<T> {
        private T variable = null;

        private Var() {
        }

        public T get() {
            return this.variable;
        }

        public void set(T var) {
            this.variable = var;
        }
    }
}

